/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	DrawingSaveAs.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

// Save the active drawing with the specified name
HRESULT DrawingSaveAs(CString fileName)
{

	START_METHOD("DrawingSaveAs")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// get active design
	IDispatch *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pActiveDoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, pActiveDoc);

	IDrawingDocOthers *doc = CAST(IDrawingDocOthers, activeDoc);

	// save the Drawing
	VARIANT_BOOL retval = NULL;
	status = activeGraphicDoc->SaveAs(fileName.AllocSysString(), TRUE, &retval);
	CHECK_RETURN_STATUS(status)

	END_METHOD("DrawingSaveAs")
}
